/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.handlers.actions;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.recipestages.RecipeStages;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ActionSetContainerStages
implements IUndoableAction {
    private final String containerName;
    private final String[] stages;

    public ActionSetContainerStages(String containerName, String[] stages) {
        this.containerName = containerName;
        this.stages = stages;
    }

    public void undo() {
        Set strings = RecipeStages.CONTAINER_STAGES.computeIfAbsent(this.containerName, s -> new HashSet());
        Arrays.asList(this.stages).forEach(strings::remove);
    }

    public String describeUndo() {
        return "Removing the stages \"" + Arrays.toString(this.stages) + "\" of container: \"" + this.containerName + "\"";
    }

    public void apply() {
        Set strings = RecipeStages.CONTAINER_STAGES.computeIfAbsent(this.containerName, s -> new HashSet());
        strings.addAll(Arrays.asList(this.stages));
    }

    public String describe() {
        return "Set the stages of container: \"" + this.containerName + "\" to: " + Arrays.toString(this.stages);
    }
}

